# راهنمای نصب اپلیکیشن پرده استور روی سرور با آپاچی

## پیش‌نیازها
- سرور لینوکس با آپاچی (CentOS / Ubuntu / Debian)
- دسترسی SSH به سرور
- دامنه یا ساب‌دامین (مثلاً app.pardehstore.com)

---

## مرحله ۱: نصب Node.js و PostgreSQL

### اوبونتو / دبیان:
```bash
# نصب Node.js 20
curl -fsSL https://deb.nodesource.com/setup_20.x | sudo bash -
sudo apt install -y nodejs

# نصب PostgreSQL
sudo apt install -y postgresql postgresql-contrib

# بررسی نصب
node -v
npm -v
psql --version
```

### CentOS / AlmaLinux:
```bash
# نصب Node.js 20
curl -fsSL https://rpm.nodesource.com/setup_20.x | sudo bash -
sudo yum install -y nodejs

# نصب PostgreSQL
sudo yum install -y postgresql postgresql-server postgresql-contrib
sudo postgresql-setup initdb
sudo systemctl start postgresql
sudo systemctl enable postgresql

# بررسی نصب
node -v
npm -v
psql --version
```

---

## مرحله ۲: ساخت دیتابیس

```bash
sudo -u postgres psql
```

داخل PostgreSQL:
```sql
CREATE USER pardehstore WITH PASSWORD 'یک_رمز_قوی_انتخاب_کنید';
CREATE DATABASE pardehstore_db OWNER pardehstore;
GRANT ALL PRIVILEGES ON DATABASE pardehstore_db TO pardehstore;
\q
```

---

## مرحله ۳: آپلود و نصب اپلیکیشن

```bash
# ساخت پوشه برای اپلیکیشن
sudo mkdir -p /var/www/pardehstore-app
cd /var/www/pardehstore-app

# فایل زیپ را به سرور آپلود کنید (مثلاً با scp یا ftp)
# سپس extract کنید:
unzip pardehstore-app.zip

# نصب وابستگی‌ها
npm install

# ساخت فایل تنظیمات محیطی
cat > .env << 'EOF'
DATABASE_URL=postgresql://pardehstore:یک_رمز_قوی_انتخاب_کنید@localhost:5432/pardehstore_db
SESSION_SECRET=یک_رشته_تصادفی_طولانی_اینجا_بنویسید
NODE_ENV=production
PORT=3000
EOF

# ساخت جداول دیتابیس
npm run db:push

# بیلد اپلیکیشن
npm run build
```

---

## مرحله ۴: تنظیم سرویس systemd (اجرای خودکار)

```bash
sudo nano /etc/systemd/system/pardehstore-app.service
```

محتوای فایل:
```ini
[Unit]
Description=PardehStore PWA Application
After=network.target postgresql.service

[Service]
Type=simple
User=www-data
WorkingDirectory=/var/www/pardehstore-app
ExecStart=/usr/bin/node dist/index.js
Restart=on-failure
RestartSec=10
Environment=NODE_ENV=production
EnvironmentFile=/var/www/pardehstore-app/.env

[Install]
WantedBy=multi-user.target
```

فعال‌سازی سرویس:
```bash
sudo systemctl daemon-reload
sudo systemctl enable pardehstore-app
sudo systemctl start pardehstore-app

# بررسی وضعیت
sudo systemctl status pardehstore-app
```

---

## مرحله ۵: تنظیم ساب‌دامین

در پنل مدیریت دامنه (DNS):
- یک رکورد A برای `app.pardehstore.com` بسازید که به IP سرورتان اشاره کند

---

## مرحله ۶: تنظیم آپاچی (Reverse Proxy)

ابتدا ماژول‌های لازم آپاچی را فعال کنید:

### اوبونتو / دبیان:
```bash
sudo a2enmod proxy proxy_http proxy_wstunnel rewrite ssl
sudo systemctl restart apache2
```

### CentOS:
ماژول‌ها معمولاً فعال هستند. اگر نبودند:
```bash
sudo yum install mod_proxy_html
```

سپس فایل VirtualHost بسازید:

```bash
sudo nano /etc/apache2/sites-available/pardehstore-app.conf
```

محتوای فایل:
```apache
<VirtualHost *:80>
    ServerName app.pardehstore.com

    ProxyPreserveHost On
    ProxyPass / http://127.0.0.1:3000/
    ProxyPassReverse / http://127.0.0.1:3000/

    ErrorLog ${APACHE_LOG_DIR}/pardehstore-app-error.log
    CustomLog ${APACHE_LOG_DIR}/pardehstore-app-access.log combined
</VirtualHost>
```

فعال‌سازی سایت:
```bash
# اوبونتو / دبیان:
sudo a2ensite pardehstore-app.conf
sudo systemctl restart apache2

# CentOS: فایل را در /etc/httpd/conf.d/ قرار دهید
sudo systemctl restart httpd
```

---

## مرحله ۷: نصب SSL (HTTPS) - اختیاری ولی توصیه‌شده

```bash
# نصب certbot
sudo apt install certbot python3-certbot-apache   # اوبونتو
# یا
sudo yum install certbot python3-certbot-apache    # CentOS

# دریافت گواهی SSL
sudo certbot --apache -d app.pardehstore.com
```

---

## مرحله ۸: تنظیم پلاگین وردپرس

1. فایل `pardehstore-pwa-installer.zip` را در وردپرس نصب کنید
2. در تنظیمات پلاگین، آدرس را وارد کنید: `https://app.pardehstore.com`
3. ذخیره کنید

---

## دستورات مفید

```bash
# مشاهده لاگ‌های اپلیکیشن
sudo journalctl -u pardehstore-app -f

# ری‌استارت اپلیکیشن
sudo systemctl restart pardehstore-app

# توقف اپلیکیشن
sudo systemctl stop pardehstore-app

# بررسی وضعیت
sudo systemctl status pardehstore-app
```

---

## عیب‌یابی

| مشکل | راه‌حل |
|-------|--------|
| اپلیکیشن بالا نمیاد | لاگ‌ها را چک کنید: `sudo journalctl -u pardehstore-app -n 50` |
| خطای دیتابیس | مطمئن شوید PostgreSQL فعال است: `sudo systemctl status postgresql` |
| صفحه سفید | بررسی کنید Node.js روی پورت 3000 فعال باشد: `curl http://localhost:3000` |
| آپاچی کار نمی‌کنه | ماژول proxy فعال باشد: `apache2ctl -M \| grep proxy` |
