import { Link } from "wouter";
import { Phone, Mail, MapPin } from "lucide-react";
import { SiInstagram, SiTelegram, SiWhatsapp } from "react-icons/si";

export default function Footer() {
  return (
    <footer className="bg-card border-t mt-12">
      <div className="max-w-7xl mx-auto px-4 py-10">
        <div className="grid grid-cols-1 md:grid-cols-3 gap-8">
          <div>
            <h3 className="text-lg font-bold mb-4" data-testid="text-footer-about-title">درباره فروشگاه</h3>
            <p className="text-sm text-muted-foreground leading-relaxed" data-testid="text-footer-about">
              فروشگاه آنلاین ما با هدف ارائه بهترین محصولات با مناسب‌ترین قیمت فعالیت می‌کند. ما متعهد به ارائه خدمات با کیفیت بالا و رضایت مشتریان هستیم.
            </p>
            <div className="flex items-center gap-3 mt-4">
              <a href="#" className="w-9 h-9 rounded-full bg-secondary flex items-center justify-center hover-elevate" data-testid="link-instagram">
                <SiInstagram className="w-4 h-4" />
              </a>
              <a href="#" className="w-9 h-9 rounded-full bg-secondary flex items-center justify-center hover-elevate" data-testid="link-telegram">
                <SiTelegram className="w-4 h-4" />
              </a>
              <a href="#" className="w-9 h-9 rounded-full bg-secondary flex items-center justify-center hover-elevate" data-testid="link-whatsapp">
                <SiWhatsapp className="w-4 h-4" />
              </a>
            </div>
          </div>

          <div>
            <h3 className="text-lg font-bold mb-4" data-testid="text-footer-links-title">لینک‌های مفید</h3>
            <nav className="space-y-2">
              <Link href="/products">
                <span className="block text-sm text-muted-foreground hover:text-foreground transition-colors cursor-pointer" data-testid="link-footer-products">محصولات</span>
              </Link>
              <Link href="/account">
                <span className="block text-sm text-muted-foreground hover:text-foreground transition-colors cursor-pointer" data-testid="link-footer-account">حساب کاربری</span>
              </Link>
              <Link href="/cart">
                <span className="block text-sm text-muted-foreground hover:text-foreground transition-colors cursor-pointer" data-testid="link-footer-cart">سبد خرید</span>
              </Link>
              <Link href="/contact">
                <span className="block text-sm text-muted-foreground hover:text-foreground transition-colors cursor-pointer" data-testid="link-footer-contact">تماس با ما</span>
              </Link>
            </nav>
          </div>

          <div>
            <h3 className="text-lg font-bold mb-4" data-testid="text-footer-contact-title">تماس با ما</h3>
            <div className="space-y-3">
              <div className="flex items-center gap-3 text-sm text-muted-foreground">
                <Phone className="w-4 h-4 shrink-0" />
                <span data-testid="text-footer-phone">۰۲۱-۱۲۳۴۵۶۷۸</span>
              </div>
              <div className="flex items-center gap-3 text-sm text-muted-foreground">
                <Mail className="w-4 h-4 shrink-0" />
                <span data-testid="text-footer-email">info@shop.com</span>
              </div>
              <div className="flex items-center gap-3 text-sm text-muted-foreground">
                <MapPin className="w-4 h-4 shrink-0" />
                <span data-testid="text-footer-address">تهران، ایران</span>
              </div>
            </div>
          </div>
        </div>

        <div className="border-t mt-8 pt-6 text-center">
          <p className="text-xs text-muted-foreground" data-testid="text-copyright">
            تمامی حقوق محفوظ است &copy; {new Date().getFullYear()}
          </p>
        </div>
      </div>
    </footer>
  );
}
