import { Phone, Mail, MapPin, Clock } from "lucide-react";
import { Card } from "@/components/ui/card";

export default function Contact() {
  return (
    <div className="max-w-4xl mx-auto px-4 py-8">
      <h1 className="text-2xl font-bold mb-6" data-testid="text-contact-title">تماس با ما</h1>

      <div className="grid md:grid-cols-2 gap-6">
        <div className="space-y-4">
          <Card className="p-5 flex items-start gap-4" data-testid="card-contact-phone">
            <div className="w-10 h-10 rounded-full bg-primary/10 flex items-center justify-center shrink-0">
              <Phone className="w-5 h-5 text-primary" />
            </div>
            <div>
              <h3 className="font-semibold mb-1">تلفن تماس</h3>
              <p className="text-sm text-muted-foreground" dir="ltr">021-12345678</p>
            </div>
          </Card>

          <Card className="p-5 flex items-start gap-4" data-testid="card-contact-email">
            <div className="w-10 h-10 rounded-full bg-primary/10 flex items-center justify-center shrink-0">
              <Mail className="w-5 h-5 text-primary" />
            </div>
            <div>
              <h3 className="font-semibold mb-1">ایمیل</h3>
              <p className="text-sm text-muted-foreground" dir="ltr">info@shop.com</p>
            </div>
          </Card>

          <Card className="p-5 flex items-start gap-4" data-testid="card-contact-address">
            <div className="w-10 h-10 rounded-full bg-primary/10 flex items-center justify-center shrink-0">
              <MapPin className="w-5 h-5 text-primary" />
            </div>
            <div>
              <h3 className="font-semibold mb-1">آدرس</h3>
              <p className="text-sm text-muted-foreground">تهران، ایران</p>
            </div>
          </Card>

          <Card className="p-5 flex items-start gap-4" data-testid="card-contact-hours">
            <div className="w-10 h-10 rounded-full bg-primary/10 flex items-center justify-center shrink-0">
              <Clock className="w-5 h-5 text-primary" />
            </div>
            <div>
              <h3 className="font-semibold mb-1">ساعات کاری</h3>
              <p className="text-sm text-muted-foreground">شنبه تا پنجشنبه - ۹ تا ۱۸</p>
            </div>
          </Card>
        </div>

        <Card className="p-5 bg-gradient-to-bl from-primary/5 to-primary/10 flex items-center justify-center min-h-[300px]">
          <div className="text-center">
            <h2 className="text-xl font-bold mb-2" data-testid="text-support-title">پشتیبانی آنلاین</h2>
            <p className="text-sm text-muted-foreground leading-relaxed max-w-xs" data-testid="text-support-desc">
              تیم پشتیبانی ما آماده پاسخگویی به سوالات شما در تمام ساعات کاری می‌باشد.
            </p>
          </div>
        </Card>
      </div>
    </div>
  );
}
