import { storage } from "./storage";
import { log } from "./index";

export async function seedDatabase() {
  try {
    const existingProducts = await storage.getProducts();
    if (existingProducts.length > 0) {
      log("Database already seeded, skipping", "seed");
      return;
    }

    log("Seeding database...", "seed");

    const cat1 = await storage.createCategory({ name: "لوازم الکترونیکی", slug: "electronics", image: "/images/cat-electronics.png", visible: true, displayOrder: 0 });
    const cat2 = await storage.createCategory({ name: "پوشاک", slug: "clothing", image: "/images/cat-clothing.png", visible: true, displayOrder: 1 });
    const cat3 = await storage.createCategory({ name: "لوازم خانگی", slug: "home", image: "/images/cat-home.png", visible: true, displayOrder: 2 });
    const cat4 = await storage.createCategory({ name: "ورزشی", slug: "sports", image: "/images/cat-sports.png", visible: true, displayOrder: 3 });

    const productsData = [
      {
        name: "هدفون بی‌سیم بلوتوثی مدل پرو",
        slug: "wireless-headphone-pro",
        description: "هدفون بی‌سیم با کیفیت صدای فوق‌العاده، قابلیت حذف نویز فعال و باتری ۳۰ ساعته. طراحی ارگونومیک و وزن سبک برای استفاده طولانی مدت.",
        shortDescription: "هدفون بی‌سیم با حذف نویز فعال",
        price: "2500000",
        salePrice: "1990000",
        sku: "HP-001",
        stockQuantity: 25,
        inStock: true,
        images: ["/images/headphone.png"],
        categoryId: cat1.id,
        featured: true,
        attributes: { برند: "پرو ساند", رنگ: "مشکی", نوع: "بی‌سیم" },
      },
      {
        name: "ساعت هوشمند اسپرت",
        slug: "smart-watch-sport",
        description: "ساعت هوشمند با قابلیت اندازه‌گیری ضربان قلب، گام‌شمار، GPS و مقاوم در برابر آب. صفحه نمایش AMOLED رنگی.",
        shortDescription: "ساعت هوشمند ضد آب با GPS",
        price: "3200000",
        salePrice: "2800000",
        sku: "SW-002",
        stockQuantity: 15,
        inStock: true,
        images: ["/images/smartwatch.png"],
        categoryId: cat1.id,
        featured: true,
        attributes: { برند: "تک واچ", رنگ: "نقره‌ای", مقاومت: "IP68" },
      },
      {
        name: "کیف چرمی مردانه",
        slug: "leather-bag-men",
        description: "کیف چرم طبیعی با طراحی کلاسیک و مدرن، دارای چندین جیب داخلی و خارجی. مناسب برای استفاده روزانه و جلسات کاری.",
        shortDescription: "کیف چرم طبیعی دستی",
        price: "1800000",
        salePrice: null,
        sku: "BG-003",
        stockQuantity: 30,
        inStock: true,
        images: ["/images/bag.png"],
        categoryId: cat2.id,
        featured: false,
        attributes: { جنس: "چرم طبیعی", رنگ: "قهوه‌ای" },
      },
      {
        name: "کفش ورزشی دویدن",
        slug: "running-shoes",
        description: "کفش ورزشی مخصوص دویدن با زیره نرم و سبک، قابلیت تهویه هوا و طراحی آیرودینامیک برای حداکثر عملکرد.",
        shortDescription: "کفش دویدن حرفه‌ای",
        price: "1500000",
        salePrice: "1200000",
        sku: "SH-004",
        stockQuantity: 40,
        inStock: true,
        images: ["/images/shoes.png"],
        categoryId: cat4.id,
        featured: true,
        attributes: { برند: "رانر", رنگ: "سفید/آبی", سایز: "۴۰-۴۵" },
      },
      {
        name: "لپ‌تاپ حرفه‌ای ۱۵ اینچ",
        slug: "laptop-15inch",
        description: "لپ‌تاپ حرفه‌ای با پردازنده نسل جدید، ۱۶ گیگابایت رم، ۵۱۲ گیگابایت SSD و کارت گرافیک مجزا. مناسب برای کارهای سنگین.",
        shortDescription: "لپ‌تاپ قدرتمند ۱۵ اینچ",
        price: "45000000",
        salePrice: "42000000",
        sku: "LP-005",
        stockQuantity: 8,
        inStock: true,
        images: ["/images/laptop.png"],
        categoryId: cat1.id,
        featured: true,
        attributes: { پردازنده: "Core i7", رم: "16GB", حافظه: "512GB SSD" },
      },
      {
        name: "جاروبرقی رباتیک هوشمند",
        slug: "robot-vacuum",
        description: "جاروبرقی رباتیک با قابلیت نقشه‌برداری، کنترل از طریق اپلیکیشن و عمر باتری ۱۲۰ دقیقه.",
        shortDescription: "جاروبرقی رباتیک با کنترل هوشمند",
        price: "8500000",
        salePrice: "7500000",
        sku: "VC-006",
        stockQuantity: 12,
        inStock: true,
        images: ["/images/vacuum.png"],
        categoryId: cat3.id,
        featured: false,
        attributes: { برند: "کلین‌تک", مدت_شارژ: "120 دقیقه" },
      },
      {
        name: "تی‌شرت ورزشی مردانه",
        slug: "sports-tshirt",
        description: "تی‌شرت ورزشی با پارچه نفس‌پذیر و خشک‌شونده سریع. مناسب برای ورزش و فعالیت‌های روزانه.",
        shortDescription: "تی‌شرت ورزشی نفس‌پذیر",
        price: "450000",
        salePrice: null,
        sku: "TS-007",
        stockQuantity: 60,
        inStock: true,
        images: ["/images/tshirt.png"],
        categoryId: cat2.id,
        featured: false,
        attributes: { جنس: "پلی‌استر", رنگ: "مشکی", سایز: "S-XXL" },
      },
      {
        name: "پاوربانک ۲۰۰۰۰ میلی‌آمپر",
        slug: "powerbank-20000",
        description: "پاوربانک با ظرفیت ۲۰۰۰۰ میلی‌آمپر ساعت، دو خروجی USB و شارژ سریع. سبک و قابل حمل.",
        shortDescription: "پاوربانک پرقدرت شارژ سریع",
        price: "850000",
        salePrice: "720000",
        sku: "PB-008",
        stockQuantity: 35,
        inStock: true,
        images: ["/images/powerbank.png"],
        categoryId: cat1.id,
        featured: false,
        attributes: { ظرفیت: "20000mAh", شارژ_سریع: "بله" },
      },
    ];

    for (const p of productsData) {
      await storage.createProduct(p);
    }

    const adminUser = await storage.getUserByPhone("09120000000");
    if (!adminUser) {
      await storage.createUser({
        phone: "09120000000",
        name: "مدیر سایت",
        role: "admin",
      });
    }

    log("Database seeded successfully", "seed");
  } catch (err: any) {
    log(`Seed error: ${err.message}`, "seed");
  }
}
