import { fileURLToPath } from "url";
import path from "path";
import express, { type Express } from "express";
import fs from "fs";

const __filename = fileURLToPath(import.meta.url);
const __dirname = path.dirname(__filename);

export function serveStatic(app: Express) {
  const distPath = path.resolve(__dirname, "..", "dist", "public");
  if (!fs.existsSync(distPath)) {
    // Fallback for direct execution if dist doesn't exist yet
    const altPath = path.resolve(__dirname, "..", "client", "dist");
    if (fs.existsSync(altPath)) {
       app.use(express.static(altPath));
       app.use("*", (_req, res) => {
         res.sendFile(path.resolve(altPath, "index.html"));
       });
       return;
    }
  }

  app.use(express.static(distPath));

  app.use("*", (req, res, next) => {
    if (req.path.startsWith("/api")) {
      return next();
    }
    const indexPath = path.resolve(distPath, "index.html");
    if (fs.existsSync(indexPath)) {
      res.sendFile(indexPath);
    } else {
      res.status(404).send("Frontend not built yet. Please run: npm run build");
    }
  });
}
