<?php
/**
 * Plugin Name: پرده استور - نصب اپلیکیشن
 * Description: نمایش بنر نصب اپلیکیشن PWA فروشگاه پرده استور
 * Version: 1.0
 * Author: PardehStore
 * Text Domain: pardehstore-pwa
 */

if (!defined('ABSPATH')) exit;

class PardehStore_PWA_Installer {
    
    private $app_url;
    
    public function __construct() {
        $this->app_url = get_option('pardehstore_pwa_url', '');
        add_action('wp_footer', array($this, 'render_install_banner'));
        add_action('admin_menu', array($this, 'add_settings_page'));
        add_action('admin_init', array($this, 'register_settings'));
    }
    
    public function add_settings_page() {
        add_options_page(
            'تنظیمات اپلیکیشن PWA',
            'اپلیکیشن PWA',
            'manage_options',
            'pardehstore-pwa',
            array($this, 'settings_page')
        );
    }
    
    public function register_settings() {
        register_setting('pardehstore_pwa_settings', 'pardehstore_pwa_url');
    }
    
    public function settings_page() {
        ?>
        <div class="wrap">
            <h1>تنظیمات اپلیکیشن PWA پرده استور</h1>
            <form method="post" action="options.php">
                <?php settings_fields('pardehstore_pwa_settings'); ?>
                <table class="form-table">
                    <tr>
                        <th scope="row"><label for="pardehstore_pwa_url">آدرس اپلیکیشن</label></th>
                        <td>
                            <input type="url" id="pardehstore_pwa_url" name="pardehstore_pwa_url" 
                                   value="<?php echo esc_attr(get_option('pardehstore_pwa_url', '')); ?>" 
                                   class="regular-text" dir="ltr" placeholder="https://your-app.replit.app" />
                            <p class="description">آدرس اپلیکیشن PWA خود را وارد کنید (مثلاً https://your-app.replit.app)</p>
                        </td>
                    </tr>
                </table>
                <?php submit_button('ذخیره تنظیمات'); ?>
            </form>
        </div>
        <?php
    }
    
    public function render_install_banner() {
        if (empty($this->app_url)) return;
        $app_url = esc_url($this->app_url);
        $icon_url = esc_url($this->app_url . '/icons/icon-192.png');
        ?>
        <style>
            #pardehstore-pwa-banner {
                display: none;
                position: fixed;
                bottom: 0;
                left: 0;
                right: 0;
                z-index: 999999;
                font-family: 'Tahoma', 'IRANSans', 'Vazir', sans-serif;
                direction: rtl;
                animation: psBannerSlideUp 0.4s ease-out;
            }
            @keyframes psBannerSlideUp {
                from { transform: translateY(100%); }
                to { transform: translateY(0); }
            }
            .ps-banner-overlay {
                position: fixed;
                top: 0; left: 0; right: 0; bottom: 0;
                background: rgba(0,0,0,0.3);
                z-index: 999998;
                display: none;
            }
            .ps-banner-content {
                background: #fff;
                border-top: 3px solid #e07a2f;
                border-radius: 16px 16px 0 0;
                box-shadow: 0 -4px 20px rgba(0,0,0,0.15);
                padding: 20px;
                max-width: 480px;
                margin: 0 auto;
                position: relative;
            }
            .ps-banner-header {
                display: flex;
                align-items: center;
                gap: 14px;
                margin-bottom: 14px;
            }
            .ps-banner-icon {
                width: 56px;
                height: 56px;
                border-radius: 14px;
                overflow: hidden;
                flex-shrink: 0;
                box-shadow: 0 2px 8px rgba(0,0,0,0.1);
            }
            .ps-banner-icon img {
                width: 100%;
                height: 100%;
                object-fit: cover;
            }
            .ps-banner-info h3 {
                margin: 0 0 4px 0;
                font-size: 16px;
                font-weight: bold;
                color: #1a1a1a;
            }
            .ps-banner-info p {
                margin: 0;
                font-size: 13px;
                color: #666;
                line-height: 1.5;
            }
            .ps-banner-close {
                position: absolute;
                top: 12px;
                left: 12px;
                background: none;
                border: none;
                font-size: 22px;
                color: #999;
                cursor: pointer;
                width: 32px;
                height: 32px;
                display: flex;
                align-items: center;
                justify-content: center;
                border-radius: 50%;
                transition: background 0.2s;
            }
            .ps-banner-close:hover {
                background: #f0f0f0;
                color: #333;
            }
            .ps-banner-actions {
                display: flex;
                gap: 10px;
                margin-top: 4px;
            }
            .ps-banner-install {
                flex: 1;
                display: flex;
                align-items: center;
                justify-content: center;
                gap: 8px;
                background: linear-gradient(135deg, #e07a2f, #d4691a);
                color: #fff;
                border: none;
                border-radius: 12px;
                padding: 12px 20px;
                font-size: 15px;
                font-weight: bold;
                font-family: inherit;
                cursor: pointer;
                text-decoration: none;
                transition: transform 0.15s, box-shadow 0.15s;
                box-shadow: 0 2px 8px rgba(224,122,47,0.3);
            }
            .ps-banner-install:hover {
                transform: translateY(-1px);
                box-shadow: 0 4px 12px rgba(224,122,47,0.4);
                color: #fff;
            }
            .ps-banner-install:active {
                transform: translateY(0);
            }
            .ps-banner-install svg {
                width: 20px;
                height: 20px;
                fill: currentColor;
            }
            .ps-banner-later {
                background: #f5f5f5;
                color: #666;
                border: none;
                border-radius: 12px;
                padding: 12px 16px;
                font-size: 13px;
                font-family: inherit;
                cursor: pointer;
                transition: background 0.2s;
            }
            .ps-banner-later:hover {
                background: #e8e8e8;
            }
            .ps-banner-features {
                display: flex;
                gap: 16px;
                justify-content: center;
                margin-top: 12px;
                padding-top: 12px;
                border-top: 1px solid #f0f0f0;
            }
            .ps-banner-feature {
                display: flex;
                align-items: center;
                gap: 4px;
                font-size: 11px;
                color: #888;
            }
            .ps-banner-feature svg {
                width: 14px;
                height: 14px;
                fill: #e07a2f;
            }
            @media (max-width: 480px) {
                .ps-banner-content { padding: 16px; }
                .ps-banner-icon { width: 48px; height: 48px; }
                .ps-banner-info h3 { font-size: 15px; }
                .ps-banner-info p { font-size: 12px; }
                .ps-banner-install { font-size: 14px; padding: 10px 16px; }
            }
        </style>
        
        <div class="ps-banner-overlay" id="pardehstore-pwa-overlay"></div>
        <div id="pardehstore-pwa-banner">
            <div class="ps-banner-content">
                <button class="ps-banner-close" id="ps-banner-close" aria-label="بستن">&times;</button>
                <div class="ps-banner-header">
                    <div class="ps-banner-icon">
                        <img src="<?php echo $icon_url; ?>" alt="پرده استور" />
                    </div>
                    <div class="ps-banner-info">
                        <h3>اپلیکیشن پرده استور</h3>
                        <p>تجربه خرید بهتر و سریع‌تر با اپلیکیشن اختصاصی ما</p>
                    </div>
                </div>
                <div class="ps-banner-actions">
                    <a href="<?php echo $app_url; ?>" class="ps-banner-install" target="_blank" rel="noopener" id="ps-banner-install-btn">
                        <svg viewBox="0 0 24 24"><path d="M13 5v6h1.17L12 13.17 9.83 11H11V5h2m2-2H9v6H5l7 7 7-7h-4V3zm4 15H5v2h14v-2z"/></svg>
                        نصب اپلیکیشن
                    </a>
                    <button class="ps-banner-later" id="ps-banner-later">بعداً</button>
                </div>
                <div class="ps-banner-features">
                    <span class="ps-banner-feature">
                        <svg viewBox="0 0 24 24"><path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm-2 15l-5-5 1.41-1.41L10 14.17l7.59-7.59L19 8l-9 9z"/></svg>
                        رایگان
                    </span>
                    <span class="ps-banner-feature">
                        <svg viewBox="0 0 24 24"><path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm-2 15l-5-5 1.41-1.41L10 14.17l7.59-7.59L19 8l-9 9z"/></svg>
                        سریع
                    </span>
                    <span class="ps-banner-feature">
                        <svg viewBox="0 0 24 24"><path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm-2 15l-5-5 1.41-1.41L10 14.17l7.59-7.59L19 8l-9 9z"/></svg>
                        بدون حجم اضافه
                    </span>
                </div>
            </div>
        </div>
        
        <script>
        (function() {
            var STORAGE_KEY = 'pardehstore_pwa_dismissed';
            var DISMISS_DAYS = 7;
            var SHOW_DELAY = 3000;
            
            function isDismissed() {
                try {
                    var dismissed = localStorage.getItem(STORAGE_KEY);
                    if (!dismissed) return false;
                    var data = JSON.parse(dismissed);
                    var now = new Date().getTime();
                    if (now - data.time > DISMISS_DAYS * 24 * 60 * 60 * 1000) {
                        localStorage.removeItem(STORAGE_KEY);
                        return false;
                    }
                    return true;
                } catch(e) { return false; }
            }
            
            function dismiss() {
                try {
                    localStorage.setItem(STORAGE_KEY, JSON.stringify({ time: new Date().getTime() }));
                } catch(e) {}
                hideBanner();
            }
            
            function showBanner() {
                var banner = document.getElementById('pardehstore-pwa-banner');
                var overlay = document.getElementById('pardehstore-pwa-overlay');
                if (banner) banner.style.display = 'block';
                if (overlay) overlay.style.display = 'block';
            }
            
            function hideBanner() {
                var banner = document.getElementById('pardehstore-pwa-banner');
                var overlay = document.getElementById('pardehstore-pwa-overlay');
                if (banner) banner.style.display = 'none';
                if (overlay) overlay.style.display = 'none';
            }
            
            if (!isDismissed()) {
                setTimeout(showBanner, SHOW_DELAY);
            }
            
            document.getElementById('ps-banner-close').addEventListener('click', dismiss);
            document.getElementById('ps-banner-later').addEventListener('click', dismiss);
            document.getElementById('pardehstore-pwa-overlay').addEventListener('click', dismiss);
            
            document.getElementById('ps-banner-install-btn').addEventListener('click', function() {
                try { localStorage.setItem(STORAGE_KEY, JSON.stringify({ time: new Date().getTime() })); } catch(e) {}
            });
        })();
        </script>
        <?php
    }
}

new PardehStore_PWA_Installer();
